from aiogram import BaseMiddleware
from aiogram.types import Message
from typing import Callable, Dict, Any, Awaitable
import time

class ThrottlingMiddleware(BaseMiddleware):
    def __init__(self, rate_limit: float = 3.0):
        self.rate_limit = rate_limit
        self.users = {}

    async def __call__(
        self,
        handler: Callable[[Message, Dict[str, Any]], Awaitable[Any]],
        event: Message,
        data: Dict[str, Any]
    ) -> Any:
        user_id = event.from_user.id
        now = time.time()
        if user_id in self.users:
            if now - self.users[user_id] < self.rate_limit:
                await event.answer(
                    "⏳ <b>انتظر قليلاً!</b>\n\nلا تبعت أكتر من طلب كل 3 ثواني",
                    parse_mode="HTML"
                )
                return
        self.users[user_id] = now
        return await handler(event, data)
