from aiogram import Router
from aiogram.filters import Command
from aiogram.types import Message
from utils.database import get_stats, get_user_stats
from config import ADMIN_IDS

router = Router()

@router.message(Command("stats"))
async def admin_stats(message: Message):
    if message.from_user.id not in ADMIN_IDS:
        users, downloads = await get_user_stats(message.from_user.id)
        await message.answer(
            f"📊 <b>إحصائياتك الشخصية</b>\n\n"
            f"📥 عدد تنزيلاتك: <b>{downloads}</b>\n\n"
            f"شكراً لاستخدامك البوت! 🤖",
            parse_mode="HTML"
        )
        return
    users, downloads = await get_stats()
    await message.answer(
        f"📊 <b>إحصائيات البوت - لوحة الأدمن</b>\n\n"
        f"━━━━━━━━━━━━━━━━━━\n"
        f"👥 إجمالي المستخدمين: <b>{users}</b>\n"
        f"📥 التنزيلات الناجحة: <b>{downloads}</b>\n"
        f"━━━━━━━━━━━━━━━━━━",
        parse_mode="HTML"
    )
